/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.thresher;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Optional;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.thresher.ThresherBlock;
import org.forsteri.ratatouille.content.thresher.ThresherBlockEntity;
import org.forsteri.ratatouille.content.thresher.ThreshingRecipe;
import org.forsteri.ratatouille.entry.CRPartialModels;
import org.forsteri.ratatouille.entry.CRRecipeTypes;

public class ThresherRenderer
extends KineticBlockEntityRenderer<ThresherBlockEntity> {
    public ThresherRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ThresherBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    protected SuperByteBuffer getRotatedModel(ThresherBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacingVertical((PartialModel)CRPartialModels.THRESHER_BLADE, (BlockState)state, (Direction)((Direction)state.getValue(ThresherBlock.HORIZONTAL_FACING)));
    }

    protected void renderItems(ThresherBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.getLevel() == null) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)be.inputInv);
        if (be.lastRecipe == null || !be.lastRecipe.matches((RecipeInput)inventoryIn, be.getLevel())) {
            Optional recipe = CRRecipeTypes.THRESHING.find(inventoryIn, be.getLevel());
            if (recipe.isEmpty()) {
                return;
            }
            be.lastRecipe = (ThreshingRecipe)recipe.get().value();
        }
        if (be.lastRecipe != null) {
            for (int slot = 0; slot < be.inputInv.getSlots(); ++slot) {
                ItemStack stack = be.inputInv.getStackInSlot(slot);
                int duration = be.lastRecipe.getProcessingDuration();
                int timer = Mth.clamp((int)be.timer, (int)0, (int)duration);
                float processPercent = (float)(duration - timer) / (float)duration * 0.5f;
                if (stack.isEmpty()) continue;
                ms.pushPose();
                ItemStack resultStack = be.lastRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
                Direction ejectDirection = be.getEjectDirection();
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                ms.scale(0.5f, 0.5f, 0.5f);
                float deltaY = 0.5f - processPercent * 0.6f;
                float deltaM = -processPercent * 1.5f + 0.5f;
                switch (ejectDirection) {
                    case NORTH: {
                        ms.translate(1.0f, deltaY, deltaM);
                        ms.mulPose(Axis.XP.rotationDegrees(66.0f));
                        break;
                    }
                    case SOUTH: {
                        ms.translate(1.0f, deltaY, 2.0f - deltaM);
                        ms.mulPose(Axis.XN.rotationDegrees(66.0f));
                        break;
                    }
                    case WEST: {
                        ms.translate(deltaM, deltaY, 1.0f);
                        ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                        ms.mulPose(Axis.XP.rotationDegrees(66.0f));
                        break;
                    }
                    case EAST: {
                        ms.translate(2.0f - deltaM, deltaY, 1.0f);
                        ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
                        ms.mulPose(Axis.XP.rotationDegrees(66.0f));
                    }
                }
                itemRenderer.renderStatic(resultStack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                ms.popPose();
                break;
            }
        }
    }
}

